#!/usr/bin/env python
# PV and EV to Clipboard

# Copyright 2007 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 070316 - first draft of this script
# 070317 - finished script
# 070320 - ignore parent tasks

import datetime, os

def hint(s):
    dlg = wx.MessageDialog(None, s, 'Hint')
    if dlg.ShowModal() == wx.ID_OK:
        pass
    dlg.Destroy()

def GetEffortHours(task):
    ''' Should look first in assignment hours, then effort hours, then duration * people
    '''
    assignments = Data.SearchByColumn(Data.Assignment, { 'TaskID': task })
    for a in assignments.keys():
        if assignments[a].get('zzStatus') == 'deleted':
            del assignments[a]

    total = 0
    # print assignments
    if assignments:
        for k, v in assignments.iteritems():
            total += v.get('EffortHours') or 0
    # print total
    if not total:
        total = Data.Task[task].get('EffortHours') or 0
    # print total
    if not total:
        total = (Data.Task[task].get('DurationHours') or 8) * (len(assignments) or 1)
    # print total
            
    return total

def Calculate(self):

    dt = Data.Database['Task']

    # ------------ project ------------------
    r = Data.Report[self.ReportID]
    pid = r.get('ProjectID') or 0
    if not pid: return

    # -------- to check tasks and resources
    tasks = Data.SearchByColumn(dt, { 'ProjectID': pid })
    for a in tasks.keys():
        # ignore parent and deleted tasks
        if tasks[a].get('SubtaskCount') or tasks[a].get('zzStatus') == 'deleted':
            del tasks[a]
    pv = {}
    ev = {}
    min_date = None
    max_date = None
    for k, v in tasks.iteritems():
        est = GetEffortHours(v['ID'])
        ped = v.get('CalculatedEndDate')
        if ped:
            if not min_date or min_date > ped:
                min_date = ped
            if not max_date or max_date < ped:
                max_date = ped
            if ped in pv:
                pv[ped] += est
            else:
                pv[ped] = est
        aed = v.get('ActualEndDate')
        if aed:
            if not min_date or min_date > aed:
                min_date = aed
            if not max_date or max_date < aed:
                max_date = aed
            if aed in ev:
                ev[aed] += est
            else:
                ev[aed] = est

    print pv, ev
    print min_date, max_date

    # -- build the result
    values = []
    one_day = datetime.timedelta(1)  # one day
    this_date = datetime.date(int(min_date[:4]), int(min_date[5:7]), int(min_date[8:]))
    last_date = datetime.date(int(max_date[:4]), int(max_date[5:7]), int(max_date[8:]))
    while this_date <= last_date:
        period = this_date.isoformat()
        values.append('%s\t%d\t%d' % (period, pv.get(period) or 0, ev.get(period) or 0))
        this_date += one_day
    
    # -- put results in the clipboard
    s = os.linesep.join( values )  

    if len(values) > 1 or len(values[0]) > 1:
        s += os.linesep

    cbData = wx.PyTextDataObject()
    cbData.SetText(s)

    if wx.TheClipboard.Open():
        wx.TheClipboard.SetData(cbData)
        wx.TheClipboard.Flush()
        wx.TheClipboard.Close()

Calculate(self)
